using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static int n, q;
    static int[] a;
    
    static void Main()
    {
        var line1 = Console.ReadLine().Split();
        n = int.Parse(line1[0]);
        q = int.Parse(line1[1]);
        
        a = new int[n + 1];
        var aLine = Console.ReadLine().Split();
        for (int i = 1; i <= n; i++)
            a[i] = int.Parse(aLine[i - 1]);
        
        for (int i = 0; i < q; i++)
        {
            var query = Console.ReadLine().Split();
            int t = int.Parse(query[0]);
            
            if (t == 1)
            {
                int k = int.Parse(query[1]);
                Console.WriteLine(Solve(k));
            }
            else
            {
                int x = int.Parse(query[1]);
                int y = int.Parse(query[2]);
                a[x] = y;
            }
        }
    }
    
    static long Solve(int k)
    {
        if (k >= n)
        {
            // Nema poteza, sve karte ostaju u ruci
            long sum = 0;
            for (int i = 1; i <= n; i++)
                sum += a[i];
            return sum;
        }
        
        // Izracunaj last[v] = poslednja pozicija karte sa vrednošcu v
        int[] last = new int[n + 1];
        for (int i = 1; i <= n; i++)
            last[a[i]] = i;
        
        // Ruka: count[v] = broj karata sa vrednošcu v u ruci
        int[] count = new int[n + 1];
        for (int i = 1; i <= k; i++)
            count[a[i]]++;
        
        // Simulacija poteza
        for (int pos = k + 1; pos <= n; pos++)
        {
            // Dodaj kartu a[pos] u ruku
            count[a[pos]]++;
            
            // Pronadi kompletnu vrednost sa najvecom sumom
            // Kompletna = last[v] <= pos (sve karte sa v su u ruci)
            int bestVal = -1;
            long bestSum = -1;
            
            for (int v = 1; v <= n; v++)
            {
                if (count[v] > 0 && last[v] <= pos)
                {
                    long sum = (long)count[v] * v;
                    if (sum > bestSum)
                    {
                        bestSum = sum;
                        bestVal = v;
                    }
                }
            }
            
            // Odigraj sve karte sa bestVal
            if (bestVal != -1)
            {
                count[bestVal] = 0;
            }
            else
            {
                // Nema kompletne vrednosti, odigraj jednu kartu sa najvecom vrednošcu
                for (int v = n; v >= 1; v--)
                {
                    if (count[v] > 0)
                    {
                        count[v]--;
                        break;
                    }
                }
            }
        }
        
        // Izracunaj sumu preostalih karata
        long result = 0;
        for (int v = 1; v <= n; v++)
            result += (long)count[v] * v;
        
        return result;
    }
}